function [upd,pred,upd1,pred1,T,V,S,F]=KalmanFilter (sigma, obs)

obsd=open('datatask9.mat');
%z=obsd.datareg(:,3);
z2=obsd.datareg(:,6);
z1=2.5-obsd.datareg(:,5);

%---------- Create matrices-------------------------
T=size(obs,1); upd=zeros(2,1,T+1); pred=zeros(2,1,T);
upd1=zeros(2,2,T+1); pred1=zeros(2,2,T);


V=zeros(T,1);S=zeros(T,1);F=zeros(T,1);

%---------- initial values for prediction ----------------
%upd(1,:)=[0,10^7] ;% Start arbitrarily large number (non stationary)
upd(1:2,1,1)=[0;0];
upd1(1:2,1:2,1)=[10^7,0;0,10^7];

%h=sigma(2);
q=[sigma(1),0;0,0];
%h=10*q;
h=100*sigma(1);

for i=1:T

%---------- Prediction equation --------------------------     
z=[z1(i),z2(i)];

pred(1:2,1,i)=upd(1:2,1,i);
pred1(1:2,1:2,i)=upd1(1:2,1:2,i)+q;

%---------- Updating equation ----------------------------

F(i)=z*pred1(1:2,1:2,i)*z'+h;


upd(1:2,1,i+1)=pred(1:2,1,i) + pred1(1:2,1:2,i)*z'/(F(i))*(obs(i)-z*pred(1:2,1,i)); 


upd1(1:2,1:2,i+1)=pred1(1:2,1:2,i) - pred1(1:2,1:2,i)*z'/(F(i))*z*pred1(1:2,1:2,i);


V(i)=obs(i)-z*pred(1:2,1,i);

S(i)=V(i)^2/F(i);
end;